clear all; close all; clc

%caricamento dati
load('grafico_a.mat')
load('grafico_b.mat')

% Determine timestep (hourly)
load_timestep = 8760/12; %monthly
simulation_timestep = 8760/365; %Daily resolution
dur=[31 28 31 30 31 30 31 31 30 31 30 31]'*24;

%waste+DH load
availability=0.15; %[%] availability of heat production
Pprod=20e6/8760; %[kW] actual excess of waste heat
ratio=[0.1 0.2 0.18 0.38 0.55 0.82 0.9 1 0.48 0.35 0.12 0.2]';
step_waste_heat=Pprod*ratio*availability*1000; %W
grafico_WIP=step_waste_heat.*dur;

%load
LOAD2 = load('Real_load_VKBtest.txt'); 
Input2 = load('input.txt');
HL2=LOAD2(:,2)*10^3; %heating load %[W]

%load
LOAD = load('Real_load.txt'); 
Input = load('input.txt');
HL=0.1*LOAD(:,2)*10^3; %heating load %[W]

% load aggregation algorithm--> I have to transform the hourly load information
% into monthly load information
months_matrix=reshape(HL,[],8760/load_timestep)';
step_DH_load=mean(months_matrix,2);%[W] load from the DH in a step form
grafico_DH=step_DH_load.*dur;

%caricamento temperatura esterna
Input = load('input.txt');
Tout = Input(:,3); % outdoor temperature
Tout_matrix=reshape(Tout,[],8760/load_timestep)';
step_Tout=mean(Tout_matrix,2);

%boreholes
Ny=7; % number of boreholes in Y direction
Nx=7; % number of boreholes in X direction
B=7.5; % boreholes distance
H=150;%[m]--> borehole depth
D=4;% [m]--> buried depth
rb=0.055;%[m] borehole radius
Ntot=Ny*Nx; % Number of boreholes
shank=70e-3;
kfill=0.6; %thermal conductivity of the backfilling material
pipe_do=32e-3;%[m] U-tube external diameter
ro=pipe_do/2;
tt=3e-3; %[m]--> U-tube thickness
pipe_di=pipe_do-2*tt; %[m]--> U-tube pipe internal diameter
ri=pipe_di/2;
pipe_k=0.42;%[W/mK]

%ground
kg=3;
rhog=3800; %kg/m^3
ag=1*10^-6;% m^2/s thermal diffusivity of the ground
cpg=kg/(rhog*ag);


%heat carrier fluid
cpw=4186;%[J/kgK]
rhow=1000;%[kg/m^3]
%evaluation of the equivalent diameter for U-tube pipes
req=(0.414*ro)+(0.5*shank);
Rbeff=abs(1/(2*pi*kfill)*log((rb/req)*sqrt(req/shank/2)));

%% INTIALIZATION 
n = (8760/simulation_timestep);

T_gr = 8;
Tapp=5;
Tb1=zeros(n,1);
Tf1=zeros(n,1);

%% BOREHOLE CONFIGURATION
% Calcola la coordinata X e Y di ciascun borehole
x = 0:B:(Nx-1)*B;
y = 0:B:(Ny-1)*B;

[X, Y] = meshgrid(x, y);

C1 = [];
C2 = [];
d = 0;

%field model
for i = 1:Ny
    for j = 1:Nx
        for z = 1:Ny
            for k = 1:Nx
                if i == z && j == k
                    d = rb^2;
                else
                    d = (X(i, j) - X(z, k))^2 + (Y(i, j) - Y(z, k))^2;
                end
                index = find(C2 == d);
                if isempty(index)
                    C2 = [C2, d];
                    C1 = [C1, 1];
                else
                    C1(index) =  C1(index) + 1;
                end
            end
        end
    end
end

ierf = @(x) (x .* erf(x)) - (1 / sqrt(pi) * (1 - exp(-x.^2)));
hc = @(s) H*s; 
dc = @(s) D*s; 
Ie = @(s) sum(C1 .* exp(-C2 .* s.^2)) / (Nx * Ny);
ILS = @(hc, dc) 2 * ierf(hc) + 2 * ierf(hc + (2 * dc)) - ierf((2 * hc) + (2 * dc)) - ierf(2 * dc);
intfunc = @(s) Ie(s) .* ILS(hc(s), dc(s)) / (H.*(s.^2));

%% HEAT PUMP MODEL
Tnom=5;
COP_nom=5.17;
COP=COP_nom*(1+0.024*(step_Tout-Tnom));
COP1=COP_nom*(1+0.024*(Tout-Tnom));

%% STORAGE OPERATION
% 
surplus = step_waste_heat - step_DH_load; 

q=surplus/Ntot/H; %flux per length
q_negative = q <0;
q(q_negative) = q(q_negative).*(1-1./COP(q_negative)); % Adjusted flux in discharging regarding heat pump COP
qp = [q(1);diff(q)]; %picewise load generation
tp = linspace(0, 8760, (8760/load_timestep)+1); %time frames according to load time step

for i = simulation_timestep:simulation_timestep:8760
        is = i/simulation_timestep;
        deltaT = 0;
        index = find(tp >= i, 1)-1;
            
        t = i*3600;
        for j = 1:index
            flux = qp(j);
            t_step = (i-tp(j))*3600;
            gfunc = (flux/ (4 * pi * kg) * integral(intfunc, 1 / sqrt(4 * ag * t_step), inf, 'ArrayValued', true));
            deltaT = deltaT + gfunc;
        end
 
        Tb1(is) = T_gr + deltaT;
        Tf1(is) = Tb1(is) + Rbeff*q(index);
        
end
Tb2 = [T_gr;Tb1];
Tf2 = [T_gr;Tf1];
time = 0:simulation_timestep:8760;
time_vector=1:1:365*24;

% Inizializzazione delle variabili per la media mensile e le deviazioni standard
time_dt = datetime(2024,1,1) + hours(time);
Tb2_monthly_avg = zeros(12, 1);
Tf2_monthly_avg = zeros(12, 1);
Tb2_std = zeros(12, 1);
Tf2_std = zeros(12, 1);

% Calcolo della media mensile e delle deviazioni standard
for i = 1:12
    indices = find(month(time_dt) == i); % Trova gli indici corrispondenti al mese i
    Tb2_monthly_avg(i) = mean(Tb2(indices));
    Tf2_monthly_avg(i) = mean(Tf2(indices));
    Tb2_std(i) = std(Tb2(indices));
    Tf2_std(i) = std(Tf2(indices));
end

% Calcolo dei valori massimi e minimi per le bande di errore
Tb2_max = Tb2_monthly_avg + Tb2_std;
Tb2_min = Tb2_monthly_avg - Tb2_std;
Tf2_max = Tf2_monthly_avg + Tf2_std;
Tf2_min = Tf2_monthly_avg - Tf2_std;

% Plot dei grafici con bande di errore
figure(1)
hold on
box on
errorbar(1:12, Tb1_monthly_avg, Tb1_std, 'o-', 'LineWidth', 1.5, 'DisplayName', 'Borehole Wall Temperature (R)');
errorbar(1:12, Tf1_monthly_avg, Tf1_std, 's-', 'LineWidth', 1.5, 'DisplayName', 'Average Fluid Temperature (R)');
errorbar(1:12, Tb2_monthly_avg, Tb2_std, 'o-', 'LineWidth', 1.5, 'DisplayName', 'Borehole Wall Temperature (N)');
errorbar(1:12, Tf2_monthly_avg, Tf2_std, 's-', 'LineWidth', 1.5, 'DisplayName', 'Average Fluid Temperature (N)');
legend('show','location','best');
xlabel('Time [month]');
ylabel('Temperature [°C]');
set(gca,'fontsize',30)

figure(2)
box on
plot(time_vector,COP1)
xlabel('Time [hours]');
ylabel('COP [-]');
set(gca,'fontsize',30)
legend('Heat pump COP')





